/*
 * Copyright (c) Dino Octavian.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution, and is available at
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * Contributors:
 *      Dino Octavian - initial API and implementation
 */
package gloodb.txmgr;

/**
 * Interface for transaction log factories.
 */
public interface TxLogFactory {
	/**
	 * Transaction log factory method.
	 * @param logConfiguration The log configuration.
	 * @return The new instance of the transaction log.
	 */
	TxLog buildLog(TxLogConfiguration logConfiguration);
}
